# Copyright 2021-2023 VMware, Inc.
# All rights reserved. -- VMware Confidential

from com.vmware.esx.settings_daemon_client import (ComplianceImpact,
   ComplianceStatus, Notification)
from com.vmware.esx.settings_daemon import data_processing_unit_client as dpuc

INFO = Notification.Type.INFO
WARNING = Notification.Type.WARNING
ERROR = Notification.Type.ERROR

COMPLIANT = ComplianceStatus.COMPLIANT
NON_COMPLIANT = ComplianceStatus.NON_COMPLIANT
INCOMPATIBLE = ComplianceStatus.INCOMPATIBLE
UNAVAILABLE = ComplianceStatus.UNAVAILABLE

RESOLUTION_SUFFIX = ".Resolution"

DPU_PREFIX = "com.vmware.vcIntegrity.lifecycle.DPUOperation."

# Error notification
DPUInfoError = 'DPUInfoError'
TaskStartError = 'TaskStartError'
TaskUpdateError = 'TaskUpdateError'
TaskStateTransitionEror = 'TaskStateTransitionEror'

# State info notification
TaskStarted = 'TaskStarted'
TaskSucceeded = 'TaskSucceeded'
TaskMaxRetry = 'TaskMaxRetry'
TaskTimeout = 'TaskTimeout'
TaskRetry = 'TaskRetry'
TaskFailed = 'TaskFailed'
DPUOperationStart = 'DPUOperationStart'
UnavailableDpuTaskFailed = 'UnavailableDpuTaskFailed'

NOTIFICATION_MSG = {
   DPUInfoError: "An error occurred when get data processing unit info.",
   TaskStartError: "Failed to start vAPI task '{1}' on data processing "
                   "unit '{2}'.",
   TaskUpdateError: "Failed to update vAPI task '{1}' on data processing"
                    " unit '{2}'.",
   TaskStarted: "VAPI task '{1}' started on data processing unit '{2}'.",
   TaskRetry: "Retry vAPI task '{1}' on data processing unit '{2}'.",
   TaskTimeout: "VAPI task '{1}' on data processing unit '{2}' timeed out.",
   TaskStateTransitionEror: "An error occurred when transitioning state of "
                            "vAPI task '{1}' on data processing unit '{2}'.",
   TaskSucceeded: "VAPI task '{1}' on data processing unit '{2}' succeeded.",
   TaskFailed: "VAPI task '{1}' on data processing unit '{2}' failed.",
   TaskMaxRetry: "VAPI task '{1}' on data processing unit '{2}' failed to "
                 "the maximum runs {3}.",
   DPUOperationStart: "Starting operation on {1} data processing units",
   UnavailableDpuTaskFailed: "VAPI task '{1}' failed on data processing unit "
                             "'{2}' at UNAVAILABLE state.",
}

RESOLUTION_MSG = {
   DPUInfoError: "Check logs for details and check dpu states.",
   TaskStartError: "Check network connection of data processing unit '{1}'.",
   TaskUpdateError: "Check network connection of data processing unit '{1}'.",
   TaskStateTransitionEror: "Check logs on data processing unit vAPI task "
                            "'{1}' of data processing unit '{2}'.",
}

commandName = dpuc.Esxcli.CommandName if hasattr(dpuc, 'Esxcli') else None
cmdStrToEnum = {
   "acceptance get"              : commandName.ACCEPTANCE_GET_CMD,
   "acceptance set"              : commandName.ACCEPTANCE_SET_CMD,
   "addon get"                   : commandName.ADDON_GET_CMD,
   "apply"                       : commandName.APPLY_CMD,
   "baseimage get"               : commandName.BASEIMAGE_GET_CMD,
   "component apply"             : commandName.COMPONENT_APPLY_CMD,
   "component get"               : commandName.COMPONENT_GET_CMD,
   "component list"              : commandName.COMPONENT_LIST_CMD,
   "component remove"            : commandName.COMPONENT_REMOVE_CMD,
   "component signature verify"  : commandName.COMPONENT_SIG_VERIFY_CMD,
   "component vib list"          : commandName.COMPONENT_VIB_LIST_CMD,
   "profile get"                 : commandName.PROFILE_GET_CMD,
   "profile install"             : commandName.PROFILE_INSTALL_CMD,
   "profile update"              : commandName.PROFILE_UPDATE_CMD,
   "profile validate"            : commandName.PROFILE_VALIDATE_CMD,
   "vib install"                 : commandName.VIB_INSTALL_CMD,
   "vib get"                     : commandName.VIB_GET_CMD,
   "vib list"                    : commandName.VIB_LIST_CMD,
   "vib remove"                  : commandName.VIB_REMOVE_CMD,
   "vib signature verify"        : commandName.VIB_SIG_VERIFY_CMD,
   "vib update"                  : commandName.VIB_UPDATE_CMD
} if commandName else {}